const { app, BrowserWindow, autoUpdater, ipcMain } = require('electron');
const path = require("path");
// const exec = require('child_process').execSync;
const os = require('os');

// Handle creating/removing shortcuts on Windows when installing/uninstalling.
if (require('electron-squirrel-startup')) { // eslint-disable-line global-require
	app.quit();
}

// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let mainWindow;
const gotTheLock = app.requestSingleInstanceLock();

if (!gotTheLock) {
	app.quit();
} else {
	app.on('second-instance', (event, commandLine, workingDirectory) => {
		// Someone tried to run a second instance, we should focus our window.
		if (mainWindow) {
			if (mainWindow.isMinimized()) 
			{
				mainWindow.restore();
			}
			mainWindow.focus();
		}
	});

	const createWindow = () => {
		// Create the browser window.
		mainWindow = new BrowserWindow({
			width: 800,
			height: 600,
			fullscreen: true,
			resizable: true,
			webPreferences: {
				preload: path.join(app.getAppPath(), 'src/preload.js')
			}
		});
		mainWindow.setMenuBarVisibility(false);

		// and load the web app.
		mainWindow.loadURL(`https://cafe.wxsweb.com:9443/`);

		// Open the DevTools.
		//mainWindow.webContents.openDevTools();

		// Emitted when the window is closed.
		mainWindow.on('closed', () => {
			// Dereference the window object, usually you would store windows
			// in an array if your app supports multi windows, this is the time
			// when you should delete the corresponding element.
			mainWindow = null;
		});
	};

	//Handle a request to show the menu bar 
	ipcMain.on('toggle-menu-bar', (event, arg) => {
		mainWindow.setMenuBarVisibility(!mainWindow.isMenuBarVisible());
		//Handle this as best effort, so don't bother sending a reply.
	});

	//Handle a request to toggle fullscreen 
	ipcMain.on('toggle-fullscreen', (event, arg) => {
		mainWindow.setFullScreen(!mainWindow.isFullScreen());
		//Handle this as best effort, so don't bother sending a reply.
	});

	if (handleSquirrelEvent()) {
		// squirrel event handled and app will exit in 1000ms, so don't do anything else
		return;
	}

	function handleSquirrelEvent() {
		if (process.argv.length === 1) {
			return false;
		}

		const ChildProcess = require('child_process');
		//const path = require('path');

		const appFolder = path.resolve(process.execPath, '..');
		const rootAtomFolder = path.resolve(appFolder, '..');
		const updateDotExe = path.resolve(path.join(rootAtomFolder, 'Update.exe'));
		const exeName = path.basename(process.execPath);

		const spawn = function(command, args) {
			let spawnedProcess, error;

			try {
			spawnedProcess = ChildProcess.spawn(command, args, {detached: true});
			} catch (error) {}

			return spawnedProcess;
		};

		const spawnUpdate = function(args) {
			return spawn(updateDotExe, args);
		};

		const squirrelEvent = process.argv[1];
		switch (squirrelEvent) {
			case '--squirrel-install':
			case '--squirrel-updated':
			// Optionally do things such as:
			// - Add your .exe to the PATH
			// - Write to the registry for things like file associations and
			//   explorer context menus

			// Install desktop and start menu shortcuts
			spawnUpdate(['--createShortcut', exeName]);

			setTimeout(app.quit, 1000);
			return true;

			case '--squirrel-uninstall':
			// Undo anything you did in the --squirrel-install and
			// --squirrel-updated handlers

			// Remove desktop and start menu shortcuts
			spawnUpdate(['--removeShortcut', exeName]);

			setTimeout(app.quit, 1000);
			return true;

			case '--squirrel-obsolete':
			// This is called on the outgoing version of your app before
			// we update to the new version - it's the opposite of
			// --squirrel-updated

			app.quit();
			return true;
		}
	};

	// const platform = os.platform() + '_' + os.arch();
	// const version = app.getVersion();

	// autoUpdater.on("error", function(error){
	// 	//Squelch errors
	// 	// console.log("ERROR!", error);
	// 	return true;
	// });

	// autoUpdater.on("checking-for-update", function(){
	// 	console.log("checking-for-update");
	// });

	// autoUpdater.on("update-available", function(){
	// 	console.log("update-available");
	// });

	// autoUpdater.on("update-not-available", function(){
	// 	console.log("update-not-available");
	// });

	// autoUpdater.on("update-downloaded", function(event){
	// 	console.log("update-downloaded", event);
	// });

	// This method will be called when Electron has finished
	// initialization and is ready to create browser windows.
	// Some APIs can only be used after this event occurs.
	app.on('ready', function() {
		// setTimeout(function(){
		// 	autoUpdater.setFeedURL('https://wxcafe-updater.herokuapp.com/update/'+platform+'/'+version);
		// 	autoUpdater.checkForUpdates();
		// }, 30000);
		createWindow();
	});

	// Quit when all windows are closed.
	app.on('window-all-closed', function () {
		// On OS X it is common for applications and their menu bar
		// to stay active until the user quits explicitly with Cmd + Q
		//if (process.platform !== 'darwin') {
		app.quit();
		//}
	});

	app.on('activate', function () {
		// On OS X it's common to re-create a window in the app when the
		// dock icon is clicked and there are no other windows open.
		if (mainWindow === null) {
			createWindow();
		}
	});

}

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and import them here.